# Artist-slider Section

**Version:** 0.13.2
**Content Hash:** 799def916d99b638

## Dependencies

This section requires the following partials:

- [commons](../partials/commons-v0.13.2.zip)

**Note:** Dependencies are not included in this package. Download them separately.

## Features

- Includes custom styles
- Includes interactive JavaScript

## Installation

### Automated Installation

```bash
./install.sh
```

The install script will:
- Detect your Metalsmith project
- Read paths from `metalsmith-components.config.json` (if present)
- Check for existing versions
- Verify dependencies
- Copy files to the correct locations

**Note:** Component paths can be customized via `metalsmith-components.config.json` in your project root. See the bundle README for details.

### Manual Installation

Copy the component files to your Metalsmith project:

```bash
cp artist-slider.njk your-project/lib/layouts/components/sections/artist-slider/
cp artist-slider.css your-project/lib/layouts/components/sections/artist-slider/
cp artist-slider.js your-project/lib/layouts/components/sections/artist-slider/
cp manifest.json your-project/lib/layouts/components/sections/artist-slider/
```

## Usage

Add the artist-slider section to your page frontmatter:

### Example 1

Configuration from component

```yaml
sections:
  - sectionType: artist-slider
    containerFields:
      inContainer: false
      isAnimated: false
      noMargin:
        top: true
        bottom: true
      noPadding:
        top: true
        bottom: true
      background:
        isDark: true
    artworks:
      source: example-artworks
      imageFolder: artworks
    cycleTime: 5000
    showDots: true
    scrollTarget: '#first-section'
```

## More Information

For complete documentation and live examples, visit:
https://metalsmith-components.netlify.app/library/artist-slider/

